<?php 

session_start();
include('connection.php');

if(isset($_SESSION['admin_login'])){

    $admin_username=$_SESSION['admin_login'];
}

?>


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        body {
            display: flex;
            height: 100vh;
            overflow: hidden;
        }

        .sidebar {
            width: 250px;
            background-color: #343a40;
            color: white;
            padding-top: 20px;
        }

        .sidebar a {
            color: white;
            padding: 15px;
            text-decoration: none;
            display: block;
        }

        .sidebar a:hover {
            background-color: #495057;
        }

        .submenu {
            display: none;
            margin-left: 20px;
        }

        .submenu a {
            font-size: 14px;
        }

        .main-content {
            flex: 1;
            padding: 20px;
            overflow-y: auto;
        }

        .card {
            border: none;
            color: white;
        }

        .card i {
            font-size: 48px;
            margin-bottom: 10px;
        }

        .card-title {
            font-size: 18px;
        }

        .card-body {
            text-align: center;
        }

        .navbar .logout {
            margin-left: 20px;
        }

        /* Mobile responsiveness */
        @media (max-width: 768px) {
            .sidebar {
                position: fixed;
                top: 0;
                left: -250px;
                height: 100%;
                transition: all 0.3s;
            }

            .sidebar.active {
                left: 0;
            }

            .main-content {
                margin-left: 0;
                padding: 10px;
            }

            .navbar-toggler {
                display: block;
            }
        }

        /* Icons */
        .card i {
            font-size: 50px;
        }

        .submenu {
            background-color: #495057;
        }
    </style>
</head>

<body>
    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <h2 class="text-left" style="margin-left: 14px;">MENU</h2>
        <a href="#" onclick="toggleSubmenu('dashboardSubmenu')">Dashboard</a>
        <div id="dashboardSubmenu" class="submenu">
            <a href="admin.php">Main Dashboard</a>
        </div>

        <a href="school_fieldapplication_adminviewregistered.php" onclick="toggleSubmenu('studentsSubmenu')">Registered</a>

        <a href="school_fieldapplication_adminviewapplications.php" onclick="toggleSubmenu('feesSubmenu')">All Applications</a>

        <a href="school_fieldapplication_adminpendingapplications.php" onclick="toggleSubmenu('subjectsSubmenu')">Pending Applications</a>

        <a href="school_fieldapplication_adminapprovedapplications.php" onclick="toggleSubmenu('teachersSubmenu')">Approved Applications</a>

        <a href="school_fieldapplication_adminrejectedapplications.php" onclick="toggleSubmenu('timetableSubmenu')">Rejected Applications</a>

          <a href="admin_update_fieldapplication_status.php" onclick="toggleSubmenu('timetableSubmenu')">Set Application Status</a>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <nav class="navbar navbar-light bg-light justify-content-between">
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation" onclick="toggleSidebar()">
                <span class="navbar-toggler-icon"></span>
            </button>
            <?php echo $admin_username;  ?>
            <span class="navbar-brand mb-0 h1">Mwalongo School Admin</span>
            <div class="d-flex">
                <span class="navbar-text">Field Application Management System (FAMS)</span>
                <a href="school_logout.php" class="btn btn-outline-danger logout">Logout</a>
            </div>
        </nav>

        <div class="alert alert-success mt-3">Welcome to Field Application Management System Dashboard!!</div>

        <!-- Dashboard Cards -->
        <div class="row g-4">
            <?php
                include('connection.php');
                // Combine all stats into one query
                $query = "
                    SELECT 
                        (SELECT COUNT(*) FROM field_registered) AS registered,
                        (SELECT COUNT(*) FROM field_registered f, field_informations s WHERE f.user_name = s.user_name) AS all_applications,
                        (SELECT COUNT(*) FROM field_informations WHERE status='Application received successfully,wait for the response') AS pending_applications,
                        (SELECT COUNT(*) FROM field_informations WHERE status='Congratulation you have been selected to conduct field practical at our school') AS approved_applications,
                        (SELECT COUNT(*) FROM field_informations WHERE status='Sorry,you have not been selected to conduct field at our school') AS rejected_applications,
                        (SELECT COUNT(*) FROM field_registered WHERE gender='MALE') AS male_applicants,
                        (SELECT COUNT(*) FROM field_registered WHERE gender='FEMALE') AS female_applicants
                    ";
                $result = mysqli_query($con, $query);
                $data = mysqli_fetch_assoc($result);
            ?>

            <!-- Dashboard Cards displaying counts -->
            <div class="col-md-3">
                <div class="card bg-primary">
                    <div class="card-body">
                        <i class="bi bi-person"></i>
                        <h5 class="card-title">Registered</h5>
                        <p class="card-text"><b><?php echo $data['registered']; ?></b></p>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card bg-success">
                    <div class="card-body">
                        <i class="bi bi-cash-stack"></i>
                        <h5 class="card-title">All Applications</h5>
                        <p class="card-text"><b><?php echo $data['all_applications']; ?></b></p>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card bg-info">
                    <div class="card-body">
                        <i class="bi bi-bank"></i>
                        <h5 class="card-title">Pending Applications</h5>
                        <p class="card-text"><b><?php echo $data['pending_applications']; ?></b></p>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card bg-danger">
                    <div class="card-body">
                        <i class="bi bi-person-fill"></i>
                        <h5 class="card-title">Approved Applications</h5>
                        <p class="card-text"><b><?php echo $data['approved_applications']; ?></b></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- More Cards -->
        <div class="row g-4 mt-3">
            <div class="col-md-3">
                <div class="card bg-warning">
                    <div class="card-body">
                        <i class="bi bi-book"></i>
                        <h5 class="card-title">Rejected Applications</h5>
                        <p class="card-text"><b><?php echo $data['rejected_applications']; ?></b></p>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card bg-secondary">
                    <div class="card-body">
                        <i class="bi bi-house"></i>
                        <h5 class="card-title">Male Applicants</h5>
                        <p class="card-text"><b><?php echo $data['male_applicants']; ?></b></p>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card bg-dark">
                    <div class="card-body">
                        <i class="bi bi-calendar"></i>
                        <h5 class="card-title">Female Applicants</h5>
                        <p class="card-text"><b><?php echo $data['female_applicants']; ?></b></p>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="card bg-primary">
                    <div class="card-body">
                        <i class="bi bi-trophy"></i>
                        <h5 class="card-title"><?php echo date('Y'); ?> Field Applicants</h5>
                        <p class="card-text"><b><?php echo $data['registered']; ?></b></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS and Icons -->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.js"></script>

    <!-- JavaScript for toggling submenus -->
    <script>
        function toggleSubmenu(submenuId) {
            var submenu = document.getElementById(submenuId);
            submenu.style.display = submenu.style.display === "block" ? "none" : "block";
        }

        function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('active');
        }
    </script>
</body>
</html>
